#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

int main(int argc, char *argv[]) {
    int rank, size;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &size);

    int N = atoi(argv[1]);
    int P = atoi(argv[2]);

    if (size != P) {
        MPI_Finalize();
        return 0;
    }

    int *v = malloc(N * sizeof(int));
    for (int i = 0; i < N; i++)
        v[i] = atoi(argv[i + 3]);

    long long sum = 0;
    long long prod = 1;
    int min = v[0];
    int max = v[0];
    int avg = 0;

    /* fiecare proces face o singură operație */
    if (rank == 0) {
        for (int i = 0; i < N; i++)
            sum += v[i];
    }
    else if (rank == 1) {
        for (int i = 0; i < N; i++)
            prod *= v[i];
    }
    else if (rank == 2) {
        for (int i = 0; i < N; i++)
            if (v[i] < min)
                min = v[i];
    }
    else if (rank == 3) {
        for (int i = 0; i < N; i++)
            if (v[i] > max)
                max = v[i];
    }
    else if (rank == 4) {
        long long s = 0;
        for (int i = 0; i < N; i++)
            s += v[i];
        avg = s / N;
    }

    /* trimite rezultate către procesul 0 */
    if (rank != 0) {
        if (rank == 1)
            MPI_Send(&prod, 1, MPI_LONG_LONG, 0, 1, MPI_COMM_WORLD);
        else if (rank == 2)
            MPI_Send(&min, 1, MPI_INT, 0, 2, MPI_COMM_WORLD);
        else if (rank == 3)
            MPI_Send(&max, 1, MPI_INT, 0, 3, MPI_COMM_WORLD);
        else if (rank == 4)
            MPI_Send(&avg, 1, MPI_INT, 0, 4, MPI_COMM_WORLD);
    }

    /* procesul 0 afișează */
    if (rank == 0) {
        printf("sum: %lld\n", sum);

        if (P >= 2) {
            MPI_Recv(&prod, 1, MPI_LONG_LONG, 1, 1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
            printf("prod: %lld\n", prod);
        }
        if (P >= 3) {
            MPI_Recv(&min, 1, MPI_INT, 2, 2, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
            printf("min: %d\n", min);
        }
        if (P >= 4) {
            MPI_Recv(&max, 1, MPI_INT, 3, 3, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
            printf("max: %d\n", max);
        }
        if (P == 5) {
            MPI_Recv(&avg, 1, MPI_INT, 4, 4, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
            printf("avg: %d\n", avg);
        }
    }

    free(v);
    MPI_Finalize();
    return 0;
}
